function sizeui(hlist,param,cat)
% this function should size the handles given according to the sizing specified in param in
% category cat
% if hlist is a cell array of groups of handles and cat is a cell array of categories
% this can be vectorized

if ~iscell(hlist)
    hlist = {hlist};
end
if ~iscell(cat)
    cat = {cat};
end


for i = 1:length(hlist)
	
	%curcat = getfield(param,cat{i});
    sizing = param.(cat{i}).sizing;
		
    % height sizing
	switch lower(sizing.htype)
	case 'extent'
        sizetoextent_h(hlist{i});
	case 'extentplus'
        sizetoextent_h(hlist{i},sizing.hplus);
	case 'fixed'
        setheight(hlist{i},sizing.h);
    case 'none'
        % don't change height
	otherwise
        disp(['Unknown Sizing Type for objects of type ' cat{i}]);
	end
    
    % width sizing
	switch lower(sizing.wtype)
	case 'extent'
        sizetoextent_w(hlist{i});
	case 'extentplus'
        sizetoextent_w(hlist{i},sizing.wplus);
	case 'fixed'
        setwidth(hlist{i},sizing.w);
    case 'none'
        % don't change width
	otherwise
        disp(['Unknown Sizing Type for objects of type ' curcat]);
	end
end
